<?php

#============================================================
# URL SHRTN             | URL shortening/forwarding script
#------------------------------------------------------------
# Script provided by Glype Media, http://www.glype.com/
#============================================================

# This is the installation file

# Check compatability
require 'check.php';

# Attempt to determine if we have mod_rewrite
$useModRewrite = function_exists('apache_get_modules') ? ( in_array('mod_rewrite',apache_get_modules()) ? true : false) : false;

# Work out example URLs
$noRewrite = $URL.'go.php?sub=<b>example</b>';
$dirRewrite = $URL.'<b>example</b>';
$subRewrite = preg_replace('@://(www\.)?@i','://<b>example</b>.',$URL);

# Check option
$url = array('no'=>'','dir'=>'');
if ( $useModRewrite ) $url['dir'] = ' checked="checked"';
else $url['no'] = ' checked="checked"';

# Top skin
include 'skin_top.php';

# Print page
echo '
<h3>Welcome to URL Shrtn. To begin the installation, we need a few details:</h3>
<form action="process.php" method="post">
	<table cellpadding="5" cellspacing="1" width="75%" align="center">
		<col width="90">
		<tr>
			<th colspan="2">MySQL Access</th>
		</tr>
		<tr>
			<td>Host:</td>
			<td><input type="text" name="mysqlhost" size="30" value="localhost"></td>
		</tr>
		<tr>
			<td>Username:</td>
			<td><input type="text" name="mysqluser" size="30"></td>
		</tr>
		<tr>
			<td>Password:</td>
			<td><input type="text" name="mysqlpass" size="30"></td>
		</tr>
		<tr>
			<td>Database:</td>
			<td><input type="text" name="mysqldb" size="30"></td>
		</tr>
	</table>
	<br>
	<table cellpadding="5" cellspacing="1" width="75%" align="center">
		<col width="90">
		<tr>
			<th colspan="2">Site Details</th>
		</tr>
		<tr>
			<td>Site Name:</td>
			<td><input type="text" name="sitename" size="30" value="URL Shrtn"></td>
		</tr>
		<tr>
			<td>URL Format:</td>
			<td>
				(1)<input type="radio" name="url" id="no" value="no"',$url['no'],'> <label for="no">',$noRewrite,'</label>
				<br>(2)<input type="radio" name="url" id="dir"  value="dir"',$url['dir'],'> <label for="dir">',$dirRewrite,'</label>
				<br>(3)<input type="radio" name="url" id="sub"  value="sub"> <label for="sub">',$subRewrite,'</label>
			</td>
		</tr>
	</table>
	<p>You can use option (1) with no additional requirements.</p>
	<p>To use options (2) and (3), you will need access to URL rewriting. On an Apache server, this is usually available through the mod_rewrite module. ',($useModRewrite ? '<em>We have detected you have this module available to you</em>.' : '<em>We have not been able to detect the presence of this module</em>. To use this option on servers other than Apache, you will need to manually configure the required rewrite.'),'</p>
	<p>For dynamic subdomains (option 3), you will require root access to your server. If you are on shared hosting, you will need to contact your host about setting up a wildcard DNS. For VPS and dedicated users, you can make the required changes yourself.</p>
	<table cellpadding="5" cellspacing="1" width="75%" align="center">
		<col width="90">
		<tr>
			<th colspan="2">Admin Account</th>
		</tr>
		<tr>
			<td>Username:</td>
			<td><input type="text" name="adminuser" size="30" value="admin"></td>
		</tr>
		<tr>
			<td>Password:</td>
			<td><input type="password" name="adminpass" size="30"></td>
		</tr>
	</table>
	<p align="center"><input type="submit" value="Install" class="button" align="center"></p>
</form>';

# Bottom skin
include 'skin_bottom.php';

?>